﻿// Wait for the DOM to be ready

$(function () { 
    $("form[name='regform']").validate({
        rules: {
            name: "required",
            father_name: "required",
            mother_name: "required",
            dob: "required",
            age_year: "required",
            age_month: "required",
            age_day: "required",
            ind_nationality: "required",
            mobile_no: {
                required: true,
                maxlength: 10,
                minlength: 10
            },
            email: {
                required: true,
                email: true
            },
            identity_marks: "required",
            current_address: "required",
            current_adr_pin: "required",
            permanent_address: "required",
            permanent_adr_pin: "required",
            ten_board: "required",
            ten_pass_year: "required",
            ten_percentage: "required",
            twelve_board: "required",
            twelve_pass_year: "required",
            twelve_percentage: "required",
            grad_exam_uni: "required",
            grad_pass_year: "required",
            grad_percentage: "required",
            llb_exam_uni: "required",
            llb_pass_year: "required",
            llb_percentage: "required",
            ddlplace: "required",
            Q_Clerk_Cum_Research_Assist: "required",
            Q_JudicialService: "required",
            Q_Judge_Lawyer: "required",
            pic: "required",
            sign: "required",
        },
        
        // Specify validation error messages
        messages: {
            name: "Please enter your first name",
            father_name: "Please enter father's name",
            mother_name: "Please enter mother's name",
            dob: "Please enter your date of birth",
            age_year: "Years",
            age_month: "Months",
            age_day: "Days",
            ind_nationality: "Please select nationality",
            mobile_no: {
                required: "Please enter mobile no.",
                minlength: "Your mobile must be at least 10 characters long"
            },
            email: "Please enter your valid email address",
            identity_marks: "Please enter any identity mark",
            current_address: "Please enter current address",
            current_adr_pin: "Please enter pin code",
            permanent_address: "Please enter permanent address",
            permanent_adr_pin: "Please enter pin code",
            ten_board: "Please enter 10th board name",
            ten_pass_year: "Please enter 10th passing year",
            ten_percentage: "Please enter scored percentage in 10th",
            twelve_board: "Please enter 12th board",
            twelve_pass_year: "Please enter 12th passing year",
            twelve_percentage: "Please enter scored percentage in 12th",
            grad_exam_uni: "Please enter graduation university name",
            grad_pass_year: "Please enter graduation passing year",
            grad_percentage: "Please enter scored percentage in graduation",
            llb_exam_uni: "Please enter LL.B./B.A. LL.B. unuversity name",
            llb_pass_year: "Please enter LL.B./B.A. LL.B. passing year",
            llb_percentage: "Please enter scored percentage in LL.B./B.A. LL.B.",
            ddlplace: "Please select a place",
            Q_Clerk_Cum_Research_Assist: "Please fill your suitable answer",
            Q_JudicialService: "Please fill your suitable answer",
            Q_Judge_Lawyer: "Please fill your suitable answer",
            pic: "Please upload your photo",
            sign: "Please upload your sign",
        },
        submitHandler: function (form) {    
            form.submit();
        }
    });
   
    $("form[name='testform']").validate({
        rules: {
            fname: "required",
        },

        // Specify validation error messages
        messages: {
            fname: "Please select first prefered place",
        },

        submitHandler: function (form) {
			form.submit();
        }
    });
  });
